<?php
/*======================================================================*\
|| #################################################################### ||
|| # DownloadsII 6.0.3 : A downloads mod for vBulletin                # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2010 by (RS_)Jelle (http://www.minatica.be/)          # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=231427           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!can_administer('canadminsettings'))
{
	print_cp_no_permission();
}

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'start';
}

// ###################### Welcome Message #######################
if ($_REQUEST['do'] == 'start')
{
	// Board should be turned off
	if ($vbulletin->options['bbactive'])
	{
		print_cp_message('You haven\'t turned off your board. You need to do this before you can continue the upgrade. It\'s necessary to avoid database errors. You can turn off your board <a href="options.php?do=options&amp;dogroup=onoff" target="_blank">here</a>.
			<br /><br /><strong><a href="upgradetov6.php">Click here to try again</a></strong>');
	}

	// Some version checking
	$products = $db->query_read("SELECT productid, version FROM " . TABLE_PREFIX . "product WHERE productid = 'ecdownloads' OR productid = 'downloads2'");
	while ($product = $vbulletin->db->fetch_array($products))
	{
		if ($product['productid'] == 'ecdownloads')
		{
			$ecversion = $product['version'];
		}
		else if ($product['productid'] == 'downloads2')
		{
			$dl2version = $product['version'];
		}
	}
	if (isset($ecversion) AND version_compare($ecversion, '5.0.4', '<'))
	{
		print_cp_message('You need to run ecDownloads 5.0.4 or higher to run this upgrade script.');
	}
	else if (isset($dl2version) AND version_compare($dl2version, '6.0.0', '>='))
	{
		print_cp_message('You are already running DownloadsII v6. You can\'t run this script again.');
	}

	print_cp_header('Upgrade DownloadsII to v6');
	print_form_header('upgradetov6', 'step1');
	print_table_header('Upgrade DownloadsII to v6');
	print_description_row('This script will update your pre v6 DownloadsII installation to version 6. Please read the readme.txt before you continue, this is not the only step you need to do!
		<br />There will be no data loss except for the votes, they will be resetted.');
	print_submit_row('Continue', 0);
	print_cp_footer();
}
else if ($_REQUEST['do'] == 'step1')
{
	print_cp_header('Upgrade DownloadsII to v6 (Step 1/5)');
	print_form_header('upgradetov6', 'step2');
	print_table_header('Upgrade DownloadsII to v6 (Step 1/5)');

	// Remove all templates
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = 'ecdownloads'");
	$rowcount = $db->affected_rows();
	print_description_row("Removed <em>$rowcount</em> old templates");

	print_submit_row('Continue to Step 2', 0);
	print_cp_footer();
}
else if ($_REQUEST['do'] == 'step2')
{
	print_cp_header('Upgrade DownloadsII to v6 (Step 2/5)');
	print_form_header('upgradetov6', 'step3');
	print_table_header('Upgrade DownloadsII to v6 (Step 2/5)');

	// Remove all phrases
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE product = 'ecdownloads'");
	$rowcount = $db->affected_rows();
	print_description_row("Removed <em>$rowcount</em> old phrases");

	// Remove the phrasetype
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE product = 'ecdownloads'");
	print_description_row('Removed old phrasetype');

	// Remove the phrasegroup
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "language DROP phrasegroup_ecdownloads");
	print_description_row('Removed old phrasegroup');

	print_submit_row('Continue to Step 3', 0);
	print_cp_footer();
}
else if ($_REQUEST['do'] == 'step3')
{
	print_cp_header('Upgrade DownloadsII to v6 (Step 3/5)');
	print_form_header('upgradetov6', 'step4');
	print_table_header('Upgrade DownloadsII to v6 (Step 3/5)');

	// Remove all settings
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "setting WHERE product = 'ecdownloads'");
	$rowcount = $db->affected_rows();
	print_description_row("Removed <em>$rowcount</em> old settings");

	// Remove the settinggroup
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "settinggroup WHERE product = 'ecdownloads'");
	print_description_row('Removed old settinggroup');

	// Remove the product, product code (install/uninstall PHP code) and product dependency
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = 'ecdownloads'");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "productcode WHERE productid = 'ecdownloads'");
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "productdependency WHERE productid = 'ecdownloads'");
	print_description_row('Removed old product');

	// Remove all plugins
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE product = 'ecdownloads'");
	print_description_row('Removed old plugins');

	// Remove usergroup permissions
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP `ecdownloadpermissions`");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP `ecexcludecatlist`");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP `ecdownloadsmaxdailydl`");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP `ecdownloadsmaxuploadtotal`");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP `ecdownloadsmaxdailyfiles`");
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "usergroup DROP `ecdownloaddelaygrp`");
	print_description_row('Removed old usergroup permissions');

	print_submit_row('Continue to Step 4', 0);
	print_cp_footer();
}
else if ($_REQUEST['do'] == 'step4')
{
	print_cp_header('Upgrade DownloadsII to v6 (Step 4/5)');
	print_form_header('upgradetov6', 'step5');
	print_table_header('Upgrade DownloadsII to v6 (Step 4/5)');

	// Heavy plastic surgery for the dl_ tables
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "dl_cats
		DROP `abbr`,
		ADD `defaultsortfield` varchar(50) NOT NULL default 'dateadded',
		ADD `defaultsortorder` ENUM('asc', 'desc') NOT NULL default 'desc'
	");
	print_description_row('Altered <em>dl_cats</em> table successfully');


	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "dl_downloads
		CHANGE `clientip` `ipaddress` varchar(16) NOT NULL default ''
	");
	print_description_row('Altered <em>dl_downloads</em> table successfully');


	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "dl_files
		CHANGE `name` `title` varchar(50) NOT NULL default '',
		ADD `extension` VARCHAR(20) BINARY NOT NULL default '',
		CHANGE `date` `dateadded` int(10) unsigned NOT NULL default '0',
		CHANGE `last` `lastdownload` int(10) unsigned NOT NULL default '0',
		ADD `lastedit` int(10) unsigned NOT NULL default '0',
		ADD `lasteditor` varchar(100) NOT NULL default '',
		ADD `lasteditorid` int(10) unsigned NOT NULL default '0',
		CHANGE `downloads` `totaldownloads` int(10) unsigned NOT NULL default '0',
		CHANGE `comments` `totalcomments` int(10) unsigned NOT NULL default '0',
		CHANGE `purgatory` `modqueue` int(1) unsigned NOT NULL default '0'
	");
	print_description_row('Altered <em>dl_files</em> table successfully');

	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "user
		CHANGE `uploads` `dl2_uploads` int(10) unsigned NOT NULL default '0',
		CHANGE `downloads` `dl2_downloads` int(10) unsigned NOT NULL default '0',
		CHANGE `comments` `dl2_comments` int(10) unsigned NOT NULL default '0'
	");
	print_description_row('Altered <em>user</em> table successfully');


	$db->query_write("DROP TABLE " . TABLE_PREFIX . "dl_votes");
	print_description_row('Dropped <em>dl_votes</em> table successfully');


	$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET rating = 0");
	print_description_row('Reset rating in the <em>dl_files</em> table');


	// Rename all remaining dl_ tables to dl2_ prefix
	$db->query_write("RENAME TABLE 	" . TABLE_PREFIX . "dl_cats TO " . TABLE_PREFIX . "dl2_categories,
					" . TABLE_PREFIX . "dl_comments TO " . TABLE_PREFIX . "dl2_comments,
					" . TABLE_PREFIX . "dl_downloads TO " . TABLE_PREFIX . "dl2_downloads,
					" . TABLE_PREFIX . "dl_files TO " . TABLE_PREFIX . "dl2_files,
					" . TABLE_PREFIX . "dl_images TO " . TABLE_PREFIX . "dl2_images,
					" . TABLE_PREFIX . "dl_main TO " . TABLE_PREFIX . "dl2_main,
					" . TABLE_PREFIX . "dl_stats TO " . TABLE_PREFIX . "dl2_stats
	");
	print_description_row('Renamed remaining <em>dl_</em> tables to the new <em>dl2_</em> prefix');


	// Create new dl2_extensions table
	$db->query_write("CREATE TABLE IF NOT EXISTS ". TABLE_PREFIX ."dl2_extensions (
		extension char(20) BINARY NOT NULL default '',
		mimetype varchar(255) NOT NULL default '',
		size int(10) unsigned NOT NULL default '0',
		width smallint(5) unsigned NOT NULL default '0',
		height smallint(5) unsigned NOT NULL default '0',
		mode smallint(5) unsigned NOT NULL default '1',
		enabled smallint(5) unsigned NOT NULL default '1',
		newwindow smallint(5) unsigned NOT NULL default '0',
		inline smallint(5) unsigned NOT NULL default '0',
		PRIMARY KEY (extension),
		KEY enabled (enabled)
	) ENGINE=MyISAM");
	print_description_row('Added new <em>dl2_extensions</em> table');


	// Create new dl2_reports table
	$db->query_write("CREATE TABLE IF NOT EXISTS ". TABLE_PREFIX ."dl2_reports (
		id int(10) unsigned NOT NULL auto_increment,
		fileid int(10) unsigned NOT NULL default '0',
		username varchar(100) NOT NULL default '',
		userid int(10) unsigned NOT NULL default '0',
		date int(10) unsigned NOT NULL default '0',
		reason text NOT NULL,
		ipaddress varchar(16) NOT NULL default '',
		PRIMARY KEY (id)
	) ENGINE=MyISAM");
	print_description_row('Added new <em>dl2_reports</em> table');


	// Create new dl2_votes table
	$db->query_write("CREATE TABLE IF NOT EXISTS ". TABLE_PREFIX ."dl2_votes (
		id int(10) unsigned NOT NULL auto_increment,
		user int(10) unsigned NOT NULL default '0',
		file int(10) unsigned NOT NULL default '0',
		value int(1) unsigned NOT NULL default '0',
		PRIMARY KEY (id)
	) ENGINE=MyISAM");
	print_description_row('Added new <em>dl2_votes</em> table');

	print_submit_row('Continue to Step 5', 0);
	print_cp_footer();
}
else if ($_REQUEST['do'] == 'step5')
{
	print_cp_header('Upgrade DownloadsII to v6 (Step 5/5)');

	// Fill in the correct file extensions
	print_dots_start('Putting the file extensions in a separate database field');

	$query = $db->query_read("SELECT `id`, `url` FROM " . TABLE_PREFIX . "dl2_files");
	while ($file = $vbulletin->db->fetch_array($query))
	{
		$file_extension = strtolower(file_extension($file['url']));
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl2_files SET `extension` = '" . $db->escape_string($file_extension) . "' WHERE `id` = $file[id]");
	}

	print_dots_stop();
	echo '<p align="center">Done!</p>';

	print_form_header('upgradetov6', 'end');
	print_submit_row('Continue to the end', 0);
	print_cp_footer();
}
else if ($_REQUEST['do'] == 'end')
{
	print_cp_header('Upgrade DownloadsII to v6 (Finished)');
	print_form_header('index', '');
	print_table_header('Upgrade DownloadsII to v6 (Finished)');
	print_description_row('The DownloadsII v6 conversion script finished all its steps. This is not the only step you need to do, continue with the readme.txt!
		<br />Because of this, it\'s pretty normal that your downloads section doesn\'t work yet. Keep your forums turned off until the end of the readme.txt!
		<br /><br /><strong>Delete this script now from your FTP for security reasons!</strong>');
	print_submit_row('Continue to the AdminCP', 0);
	print_cp_footer();
}

?>